insert into sc_stat_meter_unread_device_by_building_7day (stat_day,site_id,channel_id,building_id,device_id,date_create)
select
	DATE_FORMAT( date_add( #{date}, INTERVAL - 1 DAY ), '%Y%m%d' ),
	site_id,
	sys_id,
	building_id,
	device_id,
	now()
from (
		SELECT
			site_id,
			sys_id,
			building_id,
			device_id,
			SUM(IF(read_status = 1 ,1,0)) as unread_times,
			SUM(IF(read_status = 2 ,1,0)) as read_times
		FROM
			sc_meter_read_record
		WHERe
		read_date < DATE_FORMAT(  #{date}, '%Y%m%d' )
		AND read_date >= DATE_FORMAT( date_add( #{date}, interval -7 day), '%Y%m%d' )
		GROUP BY
			site_id,
			sys_id,
			building_id,
			device_id
) t1 WHERE t1.read_times = 0