-- 按照客户集中器进行统计抄表率
replace INTO sc_stat_meter_read_rate_by_concentrator_month ( stat_month, site_id, channel_id,meter_type_id, customer_id, concentrator_id, device_count, read_times, real_read_times, un_read_times, read_rate, date_create, date_update )
-- 按照站点内集中器统计
SELECT
	DATE_FORMAT( date_add( #{date}, INTERVAL - 1 MONTH ), '%Y%m' ),
	tmp.site_id,
	0,
	tmp.device_type_id,
	tmp.customer_id,
	tmp.concentrator_id,
	count(tmp.device_id) as device_count,
	count(1) as read_times,
	SUM(IF(tmp.real_read_times != 0 ,1,0)) as real_read_times,
	SUM(IF(tmp.un_read_times = day(LAST_DAY(date_add(#{date}, INTERVAL - 1 MONTH ))) ,1,0)) as un_read_times,
	FORMAT(SUM(IF(tmp.real_read_times != 0 ,1,0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	(
		SELECT
			site_id,
			device_type_id,
			customer_id,
			concentrator_id,
			device_id,
			SUM( IF ( read_status = 2, 1, 0 ) ) AS real_read_times,
			SUM( IF ( read_status = 1, 1, 0 ) ) AS un_read_times
		FROM
			sc_meter_read_record
		WHERE
			device_type_id  in (select device_type_id from sc_w_meter_type where parent_id = 1 and status = 1)
		AND	read_date < date_format(date_add(#{date},interval - day(#{date})+1 day) ,'%Y%m%d')
		AND read_date >= date_format(date_sub(date_sub( date_format( #{date}, '%y-%m-%d' ), INTERVAL extract( DAY FROM #{date} ) - 1 DAY ),INTERVAL 1 MONTH ),'%Y%m%d')
		GROUP BY
			site_id,
			device_type_id,
			customer_id,
			concentrator_id,
			device_id
	) tmp
	GROUP BY
			site_id,
			device_type_id,
			customer_id,
			concentrator_id
