/*
 * Decompiled with CFR 0.152.
 */
package com.huaxu.zoniot.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huaxu.zoniot.common.Constants;
import com.huaxu.zoniot.common.ResultStatus;
import com.huaxu.zoniot.common.ServiceException;
import com.huaxu.zoniot.dao.MeterReadRecordMapper;
import com.huaxu.zoniot.dao.WaterMeterMapper;
import com.huaxu.zoniot.entity.JobTask;
import com.huaxu.zoniot.entity.MeasuringData;
import com.huaxu.zoniot.entity.MeterReadRecord;
import com.huaxu.zoniot.entity.WaterMeter;
import com.huaxu.zoniot.repository.MeterReadRecordRepository;
import com.huaxu.zoniot.service.MeterReadRecordService;
import com.huaxu.zoniot.utils.RedisUtil;
import com.huaxu.zoniot.utils.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeterReadRecordServiceImpl
implements MeterReadRecordService {
    private static final Logger log = LoggerFactory.getLogger(MeterReadRecordServiceImpl.class);
    @Resource
    WaterMeterMapper waterMeterMapper;
    @Resource
    MeterReadRecordMapper meterReadRecordMapper;
    @Resource
    SnowflakeIdWorker snowflakeIdWorker;
    @Resource
    RedisUtil redisUtil;
    @Autowired
    MeterReadRecordRepository meterReadRecordRepository;

    @Override
    public int batchCreateMeterUnReadRecord(JobTask jobTask) {
        log.info("Begin batchCreateMeterUnReadRecord ,Task = {}", (Object)JSON.toJSONString((Object)jobTask));
        StopWatch clock = new StopWatch();
        clock.start();
        String context = jobTask.getContext();
        Map contextMap = (Map)JSON.parseObject((String)context, Map.class);
        int beginIndex = MapUtil.getInt((Map)contextMap, (Object)"beginIndex");
        int chunkSize = MapUtil.getInt((Map)contextMap, (Object)"chunkSize");
        int readDay = MapUtil.getInt((Map)contextMap, (Object)"readDay");
        List<WaterMeter> waterMeterList = this.waterMeterMapper.findWaterMeterListWithPage(beginIndex, chunkSize);
        int size = this.batchCreateMeterUnReadRecord(waterMeterList, readDay);
        waterMeterList.clear();
        clock.stop();
        log.info("End batchCreateMeterUnReadRecord ,Task = {},Size = {},Cost = {}s", new Object[]{JSON.toJSONString((Object)jobTask), size, clock.getTime() / 1000L});
        return size;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, timeout=36000, rollbackFor={Exception.class})
    public int batchCreateMeterUnReadRecord(List<WaterMeter> waterMeterList, Integer readDay) {
        log.info("begin batch create meter record , data size = {},readDay={}", (Object)waterMeterList.size(), (Object)readDay);
        int i = 0;
        if (this.compareMeterReadDay(readDay) < 0) {
            log.warn("Not Support Passed ReadDay = {}", (Object)readDay);
        } else {
            ArrayList<MeterReadRecord> meterReadRecordList = new ArrayList<MeterReadRecord>();
            ArrayList<MeterReadRecord> meterReadRecordListForMongo = new ArrayList<MeterReadRecord>();
            for (WaterMeter waterMeter : waterMeterList) {
                MeterReadRecord meterReadRecord = this.buildUnReadRecord(waterMeter, readDay);
                if (meterReadRecord != null) {
                    meterReadRecordList.add(meterReadRecord);
                    meterReadRecordListForMongo.add(meterReadRecord);
                }
                if (meterReadRecordList.size() != Constants.BATCH_SIZE.intValue()) continue;
                int insert = this.meterReadRecordMapper.batchInsert(meterReadRecordList);
                i += insert;
                meterReadRecordList.clear();
            }
            if (meterReadRecordList.size() != 0) {
                int insert = this.meterReadRecordMapper.batchInsert(meterReadRecordList);
                i += insert;
                meterReadRecordList.clear();
            }
            if (meterReadRecordListForMongo.size() != 0) {
                try {
                    this.meterReadRecordRepository.saveAll(meterReadRecordListForMongo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("Batch insert meter read record to mongo failed !", (Throwable)e);
                }
            }
        }
        log.info("end batch create meter record , readDay={} ,result size = {}", (Object)readDay, (Object)i);
        return i;
    }

    protected int compareMeterReadDay(int readDay) {
        Integer today = Integer.parseInt(DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMdd"));
        return readDay - today;
    }

    protected MeterReadRecord buildUnReadRecord(WaterMeter waterMeter, Integer readDay) {
        MeterReadRecord meterReadRecord = new MeterReadRecord();
        meterReadRecord.setBuildingId(waterMeter.getBuildingId());
        meterReadRecord.setCity(waterMeter.getCity());
        meterReadRecord.setCollectorId(waterMeter.getCollectorId());
        meterReadRecord.setCommunity(waterMeter.getCommunity());
        meterReadRecord.setConcentratorId(waterMeter.getConcentratorId());
        meterReadRecord.setCreateBy("system");
        meterReadRecord.setCustomerId(waterMeter.getCustomerId());
        meterReadRecord.setDateCreate(new Date());
        meterReadRecord.setBuildingId(waterMeter.getBuildingId());
        meterReadRecord.setDeviceId(waterMeter.getDeviceId());
        meterReadRecord.setDeviceNo(waterMeter.getDeviceNo());
        meterReadRecord.setDeviceTypeId(waterMeter.getDeviceTypeId());
        meterReadRecord.setId(this.snowflakeIdWorker.nextId());
        meterReadRecord.setLastCost(new BigDecimal(0));
        meterReadRecord.setLocation(waterMeter.getLocation());
        meterReadRecord.setMeterFileNo(waterMeter.getMeterFileNo());
        meterReadRecord.setMeterNo(waterMeter.getMeterNo());
        meterReadRecord.setReadStatus("1");
        meterReadRecord.setRegion(waterMeter.getRegion());
        meterReadRecord.setStatus(1);
        meterReadRecord.setReadDate(readDay);
        meterReadRecord.setSiteId(waterMeter.getSiteId());
        meterReadRecord.setSysId(waterMeter.getSysId());
        meterReadRecord.setProvince(waterMeter.getProvince());
        meterReadRecord.setLastValid(this.getMeterLastValid(waterMeter, readDay));
        meterReadRecord.setProvinceName(waterMeter.getProvinceName());
        meterReadRecord.setCityName(waterMeter.getCityName());
        meterReadRecord.setRegionName(waterMeter.getRegionName());
        meterReadRecord.setCustomerName(waterMeter.getCustomerName());
        meterReadRecord.setDeviceTypeName(waterMeter.getDeviceTypeName());
        meterReadRecord.setManufacturerId(waterMeter.getManufacturerId());
        meterReadRecord.setManufacturerName(waterMeter.getManufacturerName());
        meterReadRecord.setConcentratorNo(waterMeter.getConcentratorNo());
        meterReadRecord.setCollectorNo(waterMeter.getCollectorNo());
        meterReadRecord.setBuildingName(waterMeter.getBuildingName());
        meterReadRecord.setCommunityName(waterMeter.getCommunityName());
        meterReadRecord.setChannelNumberId(waterMeter.getChannelNumberId());
        meterReadRecord.setChannelName(waterMeter.getChannelName());
        return meterReadRecord;
    }

    protected String getMeterLastValid(WaterMeter waterMeter, Integer readDate) {
        String lastValid = "0";
        String lastValidFromCache = this.getMeterLastValidFromCache(waterMeter);
        if (StringUtils.isBlank((CharSequence)lastValidFromCache)) {
            String lastValidFromDB = this.getMeterLastValidFromDB(waterMeter, readDate);
            if (StringUtils.isNotBlank((CharSequence)lastValidFromDB)) {
                lastValid = lastValidFromDB;
            }
        } else {
            lastValid = lastValidFromCache;
        }
        return lastValid;
    }

    protected String getMeterLastValidFromDB(WaterMeter waterMeter, Integer readDate) {
        String lastValid = "";
        DateTime inputDate = DateUtil.parse((CharSequence)String.valueOf(readDate), (String)"yyyyMMdd");
        DateTime previousDate = DateUtil.offset((Date)inputDate, (DateField)DateField.DAY_OF_MONTH, (int)-1);
        int previousDay = Integer.parseInt(DateUtil.format((Date)previousDate.toJdkDate(), (String)"yyyyMMdd"));
        MeterReadRecord previousRecord = this.findRecordByMeterIdAndReadDate(waterMeter, previousDay);
        if (previousRecord != null) {
            lastValid = previousRecord.getLastValid();
        }
        return lastValid;
    }

    protected String getMeterLastValidFromCache(WaterMeter waterMeter) {
        MeasuringData measuringData;
        String lastValid = "";
        Map<String, MeasuringData> meterLastData = this.getMeterLastDataFromCache(waterMeter.getDeviceId());
        if (meterLastData != null && StringUtils.isNotBlank((CharSequence)(measuringData = meterLastData.get(waterMeter.getReadingMeasuringCode())).getMeasuringVaule())) {
            lastValid = measuringData.getMeasuringVaule();
        }
        return lastValid;
    }

    protected Map<String, MeasuringData> getMeterLastDataFromCache(Long deviceId) {
        Map data = null;
        String deviceDataJsonStr = this.redisUtil.get("LAST-METER-DATA:" + deviceId);
        if (StringUtils.isNotBlank((CharSequence)deviceDataJsonStr)) {
            data = (Map)JSON.parseObject((String)deviceDataJsonStr, (TypeReference)new TypeReference<Map<String, MeasuringData>>(){}, (Feature[])new Feature[0]);
        }
        return data;
    }

    protected Date getDateFromMeterData(Map<String, MeasuringData> measuringData) {
        MeasuringData timeData = measuringData.get("TIME");
        String timeValue = timeData.getMeasuringVaule();
        Date date = DateUtil.parse((CharSequence)timeValue, (String)"yyyyMMddHHmmss").toJdkDate();
        return date;
    }

    protected void setMeterLastDataToCache(Long deviceId, Map<String, MeasuringData> measuringData) {
        this.redisUtil.set("LAST-METER-DATA:" + deviceId, JSON.toJSONString(measuringData));
    }

    @Override
    public void meterReading(WaterMeter waterMeter, Map<String, MeasuringData> measuringData, Integer readDay) {
        log.debug("-----begin meter reading , meter = {},readDay = {}", (Object)waterMeter.getDeviceId(), (Object)readDay);
        StopWatch clock = new StopWatch();
        clock.start();
        try {
            Date readTime;
            if (measuringData == null) {
                log.error("\u6284\u8868\u6570\u636e\u4e3a\u7a7a,{}\u6284\u8868\u5931\u8d25", (Object)waterMeter.getDeviceId());
                throw new ServiceException(ResultStatus.READING_ERROR_1);
            }
            Date sendTime = this.getDateFromMeterData(measuringData);
            DateTime readDate = DateUtil.parse((CharSequence)String.valueOf(readDay), (String)"yyyyMMdd");
            int hour = 24;
            if (sendTime.before((Date)DateUtil.offsetHour((Date)readDate, (int)-1)) || sendTime.after((Date)DateUtil.offsetHour((Date)readDate, (int)hour))) {
                log.error("\u8868{}\u6570\u636e\u5f02\u5e38,\u6284\u8868\u65f6\u95f4\u4e0e\u4e0a\u62a5\u65f6\u95f4\u4e0d\u5339\u914d,\u4e0a\u62a5\u65f6\u95f4{} != \u672c\u6b21\u6284\u8868\u65f6\u95f4{}", new Object[]{waterMeter.getDeviceId(), sendTime, readDate});
                throw new ServiceException(ResultStatus.READING_ERROR_2);
            }
            MeterReadRecord record = this.findRecordByMeterIdAndReadDate(waterMeter, readDay);
            if (record == null) {
                record = this.buildUnReadRecord(waterMeter, readDay);
                if (record != null) {
                    this.meterReadRecordMapper.insert(record);
                    this.meterReadRecordRepository.insert(record);
                } else {
                    throw new ServiceException(ResultStatus.READING_ERROR_3);
                }
            }
            if (record.getReadStatus().equals("2") && sendTime.before(readTime = record.getReadTime())) {
                log.error("\u8868{}\u6570\u636e\u5f02\u5e38,\u6284\u8868\u65f6\u95f4\u4e0e\u4e0a\u62a5\u65f6\u95f4\u9519\u4e71,\u4e0a\u62a5\u65f6\u95f4{} != \u4e0a\u6b21\u6284\u8868\u65f6\u95f4{}", new Object[]{waterMeter.getDeviceId(), sendTime, readTime});
                throw new ServiceException(ResultStatus.READING_ERROR_3);
            }
            String currentReading = this.getReadingFromMeterData(waterMeter, measuringData);
            if (StringUtils.isBlank((CharSequence)currentReading)) {
                log.error("\u8868{}\u6570\u636e\u5f02\u5e38,\u6570\u636e\u65e0\u6700\u65b0\u6b62\u5ea6,MeasuringData = {}", (Object)waterMeter.getDeviceId(), (Object)JSON.toJSONString(measuringData));
                throw new ServiceException(ResultStatus.READING_ERROR_4);
            }
            BigDecimal todayCost = this.calculateTodayCost(currentReading, new BigDecimal(this.getMeterLastValid(waterMeter, readDay)), record);
            MeterReadRecord update = new MeterReadRecord();
            update.setId(record.getId());
            update.setLastCost(todayCost);
            update.setReadData(currentReading);
            update.setLastValid(currentReading);
            update.setReadStatus("2");
            update.setDateUpdate(new Date());
            update.setReadTime(sendTime);
            update.setUpdateBy("system");
            this.meterReadRecordMapper.updateByPrimaryKeySelective(update);
            try {
                record.setLastSendData(this.getMeasuringValueMap(measuringData));
                update.setLastCost(todayCost);
                record.setReadData(currentReading);
                record.setLastValid(currentReading);
                record.setReadStatus("2");
                record.setDateUpdate(new Date());
                record.setReadTime(sendTime);
                record.setUpdateBy("system");
                this.meterReadRecordRepository.save(record);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Update meter record to mongo failed!", (Throwable)e);
            }
            this.setMeterLastDataToCache(waterMeter.getDeviceId(), measuringData);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                log.error("\u6284\u8868\u5931\u8d25", (Throwable)e);
            }
            e.printStackTrace();
            log.error("\u6284\u8868\u5931\u8d25", (Throwable)e);
        }
        clock.stop();
        log.debug("-----end meter reading , meter = {},readDay = {},Cost = {}ms", new Object[]{waterMeter.getDeviceId(), readDay, clock.getTime()});
    }

    protected Map<String, String> getMeasuringValueMap(Map<String, MeasuringData> measuringData) {
        HashMap<String, String> measuringValueMap = new HashMap<String, String>(measuringData.size());
        for (Map.Entry<String, MeasuringData> next : measuringData.entrySet()) {
            measuringValueMap.put(next.getValue().getMeasuringCode(), next.getValue().getMeasuringVaule());
        }
        return measuringValueMap;
    }

    @Override
    public void meterReading(Long meterId, Map<String, MeasuringData> measuringData) {
        WaterMeter meter = this.waterMeterMapper.findWaterMeterById(meterId);
        Integer readDay = Integer.parseInt(DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMdd"));
        this.meterReading(meter, measuringData, readDay);
    }

    protected String getReadingFromMeterData(WaterMeter waterMeter, Map<String, MeasuringData> measuringData) {
        MeasuringData readingData = measuringData.get(waterMeter.getReadingMeasuringCode());
        String readingValue = readingData.getMeasuringVaule();
        return readingValue;
    }

    protected BigDecimal calculateTodayCost(String currentReading, BigDecimal lastValid, MeterReadRecord record) {
        BigDecimal lastCost = record.getLastCost();
        BigDecimal currentValid = new BigDecimal(currentReading);
        BigDecimal cost = currentValid.subtract(lastValid).add(lastCost);
        return cost;
    }

    @Override
    public int deleteMeterRecord(WaterMeter waterMeter, Integer readDay) {
        return this.meterReadRecordMapper.deleteRecordByReadDayAndDeviceId(waterMeter.getDeviceId(), readDay);
    }

    @Override
    public MeterReadRecord findRecordByMeterIdAndReadDate(WaterMeter waterMeter, Integer readDate) {
        MeterReadRecord record = this.meterReadRecordMapper.findRecordByReadDayAndDeviceId(waterMeter.getDeviceId(), readDate);
        return record;
    }

    public static void main(String[] args) {
    }
}

