-- 按照客户集中器进行统计抄表率
replace INTO sc_stat_meter_read_rate_by_concentrator_15day( stat_day, site_id, channel_id,meter_type_id, customer_id, concentrator_id, device_count, read_times, real_read_times, un_read_times, read_rate, date_create, date_update )
SELECT
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	tmp.site_id,
	0,
	tmp.device_type_id,
	tmp.customer_id,
	tmp.concentrator_id,
	count(tmp.device_id) as device_count,
	count(1) as read_times,  
	SUM(IF(tmp.real_read_times != 0 ,1,0)) as real_read_times,
	SUM(IF(tmp.un_read_times = 15 ,1,0)) as un_read_times,
	FORMAT(SUM(IF(tmp.real_read_times != 0 ,1,0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	(
		SELECT
			site_id,
			device_type_id,
			customer_id,
			concentrator_id,
			device_id,
			SUM( IF ( read_status = 2, 1, 0 ) ) AS real_read_times,
			SUM( IF ( read_status = 1, 1, 0 ) ) AS un_read_times 
		FROM
			sc_meter_read_record 
		WHERE
			device_type_id  in (select device_type_id from sc_w_meter_type where parent_id = 1 and status = 1)
		and	read_date < DATE_FORMAT( #{date}, '%Y%m%d' )
		AND read_date >= DATE_FORMAT( date_add(#{date}, interval -15 day), '%Y%m%d' ) 
		GROUP BY
			site_id,
			device_type_id,
			customer_id,
			concentrator_id,
			device_id 
	) tmp
	GROUP BY
			site_id,
			device_type_id,
			customer_id,
			concentrator_id
