/*
 * Decompiled with CFR 0.152.
 */
package com.huaxu.zoniot.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private RedisTemplate<String, String> redisTemplate;
    private JedisConnectionFactory jedisConnectionFactory;

    public RedisUtil(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setExpire(byte[] key, byte[] value, long time) {
        this.redisTemplate.execute(connection -> {
            connection.set(key, value);
            connection.expire(key, time);
            log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========\u7f13\u5b58\u65f6\u95f4\u4e3a{}\u79d2", (Object)key, (Object)time);
            return 1L;
        });
    }

    public void setExpire(byte[] key, byte[] value) {
        this.redisTemplate.execute(connection -> {
            connection.set(key, value);
            log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========", (Object)key);
            return 1L;
        });
    }

    public void setExpire(String key, long time) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            connection.expire(serializer.serialize((Object)key), time);
            log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========\u7f13\u5b58\u65f6\u95f4\u4e3a{}\u79d2", (Object)key, (Object)time);
            return 1L;
        });
    }

    public void setExpire(String key, String value, long time) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = serializer.serialize((Object)value);
            connection.set(keys, values);
            connection.expire(keys, time);
            log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========\u7f13\u5b58\u65f6\u95f4\u4e3a{}\u79d2", (Object)key, (Object)time);
            return 1L;
        });
    }

    public void setExpire(String[] keys, String[] values, long time) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            for (int i = 0; i < keys.length; ++i) {
                byte[] bKeys = serializer.serialize((Object)keys[i]);
                byte[] bValues = serializer.serialize((Object)values[i]);
                connection.set(bKeys, bValues);
                connection.expire(bKeys, time);
                log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========\u7f13\u5b58\u65f6\u95f4\u4e3a:{}\u79d2", (Object)keys[i], (Object)time);
            }
            return 1L;
        });
    }

    public void set(String[] keys, String[] values) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            for (int i = 0; i < keys.length; ++i) {
                byte[] bKeys = serializer.serialize((Object)keys[i]);
                byte[] bValues = serializer.serialize((Object)values[i]);
                connection.set(bKeys, bValues);
                log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{}", (Object)keys[i]);
            }
            return 1L;
        });
    }

    public void set(String key, String value) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = serializer.serialize((Object)value);
            connection.set(keys, values);
            log.info("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{}", (Object)key);
            return 1L;
        });
    }

    public List<String> willExpire(String key, long time) {
        ArrayList<String> keysList = new ArrayList<String>();
        this.redisTemplate.execute(connection -> {
            Set keys = this.redisTemplate.keys((Object)(key + "*"));
            for (String key1 : keys) {
                Long ttl = connection.ttl(key1.getBytes(DEFAULT_CHARSET));
                if (0L > ttl || ttl > 2L * time) continue;
                keysList.add(key1);
            }
            return keysList;
        });
        return keysList;
    }

    public Set<String> keys(String keyPatten) {
        return (Set)this.redisTemplate.execute(connection -> this.redisTemplate.keys((Object)(keyPatten + "*")));
    }

    public byte[] get(byte[] key) {
        byte[] result = (byte[])this.redisTemplate.execute(connection -> connection.get(key));
        return result;
    }

    public String get(String key) {
        String resultStr = (String)this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = connection.get(keys);
            return (String)serializer.deserialize(values);
        });
        return resultStr;
    }

    public Map<String, String> getKeysValues(String keyPatten) {
        log.info("[redisTemplate redis]  getValues()  patten={} ", (Object)keyPatten);
        return (Map)this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            HashMap<String, String> maps = new HashMap<String, String>();
            Set keys = this.redisTemplate.keys((Object)(keyPatten + "*"));
            for (String key : keys) {
                byte[] bKeys = serializer.serialize((Object)key);
                byte[] bValues = connection.get(bKeys);
                String value = (String)serializer.deserialize(bValues);
                maps.put(key, value);
            }
            return maps;
        });
    }

    public HashOperations<String, String, String> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public void putHashValue(String key, String hashKey, String hashValue) {
        log.info("[redisTemplate redis]  putHashValue()  key={},hashKey={},hashValue={} ", new Object[]{key, hashKey, hashValue});
        this.opsForHash().put((Object)key, (Object)hashKey, (Object)hashValue);
    }

    public Object getHashValues(String key, String hashKey) {
        log.info("[redisTemplate redis]  getHashValues()  key={},hashKey={}", (Object)key, (Object)hashKey);
        return this.opsForHash().get((Object)key, (Object)hashKey);
    }

    public void delHashValues(String key, Object ... hashKeys) {
        log.info("[redisTemplate redis]  delHashValues()  key={}", (Object)key);
        this.opsForHash().delete((Object)key, hashKeys);
    }

    public Map<String, String> getHashValue(String key) {
        log.info("[redisTemplate redis]  getHashValue()  key={}", (Object)key);
        return this.opsForHash().entries((Object)key);
    }

    public void putHashValues(String key, Map<String, String> map) {
        this.opsForHash().putAll((Object)key, map);
    }

    public long dbSize() {
        return (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
    }

    public String flushDB() {
        return (String)this.redisTemplate.execute(connection -> {
            connection.flushDb();
            return "ok";
        });
    }

    public boolean exists(String key) {
        return (Boolean)this.redisTemplate.execute(connection -> connection.exists(key.getBytes(DEFAULT_CHARSET)));
    }

    public long del(String ... keys) {
        return (Long)this.redisTemplate.execute(connection -> {
            long result = 0L;
            for (String key : keys) {
                result = connection.del((byte[][])new byte[][]{key.getBytes(DEFAULT_CHARSET)});
            }
            return result;
        });
    }

    public long del(byte[] ... keys) {
        return (Long)this.redisTemplate.execute(connection -> {
            long result = 0L;
            for (byte[] key : keys) {
                result = connection.del((byte[][])new byte[][]{key});
            }
            return result;
        });
    }

    protected RedisSerializer<String> getRedisSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    public long incr(String key) {
        return (Long)this.redisTemplate.execute(connection -> {
            RedisSerializer<String> redisSerializer = this.getRedisSerializer();
            return connection.incr(redisSerializer.serialize((Object)key));
        });
    }

    public ListOperations<String, String> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public Long leftPush(String key, String value) {
        return this.opsForList().leftPush((Object)key, (Object)value);
    }

    public String leftPop(String key) {
        return (String)this.opsForList().leftPop((Object)key);
    }

    public Long in(String key, String value) {
        return this.opsForList().rightPush((Object)key, (Object)value);
    }

    public String rightPop(String key) {
        return (String)this.opsForList().rightPop((Object)key);
    }

    public Long length(String key) {
        return this.opsForList().size((Object)key);
    }

    public void remove(String key, long i, String value) {
        this.opsForList().remove((Object)key, i, (Object)value);
    }

    public void set(String key, long index, String value) {
        this.opsForList().set((Object)key, index, (Object)value);
    }

    public List<String> getList(String key, int start, int end) {
        return this.opsForList().range((Object)key, (long)start, (long)end);
    }

    public Long leftPushAll(String key, List<String> list) {
        return this.opsForList().leftPushAll((Object)key, list);
    }

    public void insert(String key, long index, String value) {
        this.opsForList().set((Object)key, index, (Object)value);
    }

    public RedisAtomicLong getRedisAtomicLong(String key) {
        return new RedisAtomicLong(key, (RedisConnectionFactory)this.jedisConnectionFactory);
    }

    public void doZincrby(String key, Integer increment, String member) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> redisSerializer = this.getRedisSerializer();
            return connection.zIncrBy(redisSerializer.serialize((Object)key), (double)increment.intValue(), redisSerializer.serialize((Object)member));
        });
    }

    public List<String> doZrevrange(String key, Integer start, Integer end) {
        ArrayList<String> stringList = new ArrayList<String>();
        RedisSerializer<String> redisSerializer = this.getRedisSerializer();
        Set strBytes = (Set)this.redisTemplate.execute(connection -> connection.zRevRange(redisSerializer.serialize((Object)key), (long)start.intValue(), (long)end.intValue()));
        Iterator byteIter = strBytes.iterator();
        while (byteIter.hasNext()) {
            stringList.add((String)redisSerializer.deserialize((byte[])byteIter.next()));
        }
        return stringList;
    }

    public void setAdd(String key, String value) {
        this.redisTemplate.opsForSet().add((Object)key, (Object[])new String[]{value});
    }

    public void setRemove(String key, String value) {
        this.redisTemplate.opsForSet().remove((Object)key, new Object[]{value});
    }

    public Set<String> members(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }
}

