-- 按照客户小区统计抄表率
replace into sc_stat_meter_read_rate_by_community_15day(stat_day,site_id,channel_id,meter_type_id,customer_id,community_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
-- 按照站点小区进行统计
SELECT
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	tmp.site_id,
	0,
	tmp.device_type_id,
	tmp.customer_id,
	tmp.community,
	count(tmp.device_id) as device_count,
	count(1) as read_times,  
	SUM(IF(tmp.real_read_times != 0 ,1,0)) as real_read_times,
	SUM(IF(tmp.un_read_times = 15 ,1,0)) as un_read_times,
	FORMAT(SUM(IF(tmp.real_read_times != 0 ,1,0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	(
		SELECT
			site_id,
			device_type_id,
			customer_id,
			community,
			device_id,
			SUM( IF ( read_status = 2, 1, 0 ) ) AS real_read_times,
			SUM( IF ( read_status = 1, 1, 0 ) ) AS un_read_times 
		FROM
			sc_meter_read_record 
		WHERE
			read_date < DATE_FORMAT( #{date}, '%Y%m%d' )
		AND read_date >= DATE_FORMAT( date_add(#{date}, interval -15 day), '%Y%m%d' )
		and device_type_id in (15,20)
		GROUP BY
			site_id,
			device_type_id,
			customer_id,
			community,
			device_id
	) tmp
	GROUP BY
			site_id,
			device_type_id,
			customer_id,
			community