-- 按照客户采集器进行抄表率统计
INSERT INTO sc_stat_meter_read_rate_by_collector (stat_day,site_id,channel_id,meter_type_id,customer_id,concentrator_id,collector_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
-- 按照站点集中器进行统计
SELECT
	DATE_FORMAT( date_add(:date, interval -1 day), '%Y%m%d' ),
	site_id, -- 所有站点
	0, -- 场景
	device_type_id, -- 表类型
	customer_id, -- 客户
	concentrator_id, -- 集中器
	collector_id , -- 采集器
	count(DISTINCT device_id) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数 
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	sc_meter_read_record
where read_date < DATE_FORMAT( :date, '%Y%m%d' ) 
AND read_date >= DATE_FORMAT( date_add(:date, interval - 1 day), '%Y%m%d' ) 
and device_type_id in (17,18,19)
group by
	site_id,device_type_id,customer_id,concentrator_id,collector_id 