-- 按照客户小区统计抄表率
replace into sc_stat_meter_read_rate_by_community(stat_day,site_id,channel_id,meter_type_id,customer_id,community_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
-- 按照站点小区进行统计
SELECT
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	site_id, -- 所有站点
	0, -- 所有场景
	device_type_id, -- 表类型
	customer_id, -- 客户
	community, -- 小区
	count(distinct device_id) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	sc_meter_read_record
where read_date < DATE_FORMAT( #{date}, '%Y%m%d' )
AND read_date >= DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' )
and device_type_id in (15,20)
group by
	site_id,device_type_id,customer_id,community