insert into sc_stat_meter_unread_device_by_building_month (stat_day,site_id,channel_id,building_id,device_id,date_create)
SELECT
	DATE_FORMAT( date_add( #{date}, INTERVAL - 1 MONTH ), '%Y%m' ),
	site_id,
	sys_id,
	building_id,
	device_id,
	now()
FROM
	sc_meter_read_record 
WHERE
	period_diff(date_format(#{date} , '%Y%m') , date_format(`read_date`, '%Y%m')) =1
AND read_status = 1 
GROUP BY
	site_id,
	sys_id,
	building_id,
	device_id 
HAVING
	count(1) = day(LAST_DAY(date_add(#{date}, INTERVAL - 1 MONTH )))