replace into sc_stat_meter_read_rate_by_building_month (stat_day,site_id,channel_id,customer_id,building_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
SELECT
	DATE_FORMAT( date_add(#{date}, interval -1 MONTH), '%Y%m' ),
	tmp.site_id,
	tmp.sys_id,
	tmp.customer_id,
	tmp.building_id,
	count(tmp.device_id) as device_count,
	count(1) as read_times,  
	SUM(IF(tmp.real_read_times != 0 ,1,0)) as real_read_times,
	SUM(IF(tmp.un_read_times = day(LAST_DAY(date_add(#{date}, INTERVAL - 1 MONTH ))) ,1,0)) as un_read_times,
	FORMAT(SUM(IF(tmp.real_read_times != 0 ,1,0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
FROM
	(
		SELECT
			site_id,
			sys_id,
			customer_id,
			building_id,
			device_id,
			SUM( IF ( read_status = 2, 1, 0 ) ) AS real_read_times,
			SUM( IF ( read_status = 1, 1, 0 ) ) AS un_read_times 
		FROM
			sc_meter_read_record 
		WHERE
		    period_diff(date_format(#{date} , '%Y%m') , date_format(`read_date`, '%Y%m')) =1
		GROUP BY
			site_id,
			sys_id,
			customer_id,
			building_id,
			device_id 
	) tmp
	GROUP BY
			site_id,
			sys_id,
			customer_id,
			building_id
	