replace into sc_stat_meter_read_rate_by_community (stat_day,site_id,channel_id,customer_id,community_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
-- 所有站点统计
select
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	0,  -- 所有站点
	0,  -- 所有场景
	0,  -- 所有客户
	0,  -- 所有小区
	count(1) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数 
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
from
	sc_meter_read_record 
where 
	read_date = DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' )
-- 所有站点按照建筑统计
union all
select
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	0,  -- 所有站点
	0,  -- 所有场景
	0,  -- 所有客户
	community,  -- 小区
	count(1) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数 
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
from
	sc_meter_read_record 
where 
	read_date = DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' )
group by community
-- 按照小区统计
union all 
select
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	0,  -- 所有站点
	0,  -- 所有场景
	customer_id,  -- 客户
	community,  -- 小区
	count(1) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数 
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
from
	sc_meter_read_record 
where 
	read_date = DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' )
	group by customer_id,community
-- 按照客户的小区统计
