/*
 * Decompiled with CFR 0.152.
 */
package com.huaxu.zoniot.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.huaxu.zoniot.common.TaskState;
import com.huaxu.zoniot.dao.JobTaskMapper;
import com.huaxu.zoniot.dao.WaterMeterMapper;
import com.huaxu.zoniot.entity.JobResult;
import com.huaxu.zoniot.entity.JobTask;
import com.huaxu.zoniot.service.JobTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JobTaskServiceImpl
implements JobTaskService {
    private static final Logger log = LoggerFactory.getLogger(JobTaskServiceImpl.class);
    @Value(value="${task.chunk.size}")
    int chunkSize;
    @Autowired
    WaterMeterMapper waterMeterMapper;
    @Autowired
    JobTaskMapper jobTaskMapper;

    @Override
    public List<JobTask> splitJob(String jobName, Map<String, Object> jobParameter) {
        ArrayList<JobTask> taskList = new ArrayList<JobTask>();
        Long totalSize = this.waterMeterMapper.countWaterMeter();
        Integer taskCount = totalSize.intValue() / this.chunkSize + 1;
        for (int i = 0; i < taskCount; ++i) {
            Integer beginIndex = i * this.chunkSize;
            Integer endIndex = (i + 1) * this.chunkSize;
            if (endIndex > totalSize.intValue()) {
                endIndex = totalSize.intValue();
            }
            Integer taskSize = endIndex - beginIndex;
            HashMap<String, Integer> context = new HashMap<String, Integer>(4);
            context.put("beginIndex", beginIndex);
            context.put("endIndex", endIndex);
            context.put("chunkSize", this.chunkSize);
            context.put("taskSize", taskSize);
            jobParameter.putAll(context);
            JobTask task = new JobTask();
            task.setCreateTime(new Date());
            task.setJobName(jobName);
            task.setTaskState(TaskState.PREPARED.getCode());
            task.setContext(JSON.toJSONString(jobParameter));
            taskList.add(task);
        }
        if (taskList.size() != 0) {
            this.jobTaskMapper.batchInsert(taskList);
        }
        return taskList;
    }

    @Override
    public int updateTaskState(int taskId, TaskState taskState, String remark) {
        JobTask jobTask = new JobTask();
        jobTask.setTaskId(taskId);
        jobTask.setTaskState(taskState.getCode());
        jobTask.setRemark(StrUtil.sub((CharSequence)remark, (int)0, (int)255));
        if (taskState.getCode() == TaskState.COMPLETED.getCode()) {
            jobTask.setCompleteTime(new Date());
        }
        return this.jobTaskMapper.updateByPrimaryKeySelective(jobTask);
    }

    @Override
    public JobTask findTask(int taskId) {
        return this.jobTaskMapper.selectByPrimaryKey(taskId);
    }

    @Override
    public boolean judgeTaskComplete(JobTask task) {
        return this.judgeTaskState(task, TaskState.COMPLETED);
    }

    @Override
    public boolean judgeTaskFailed(JobTask task) {
        return this.judgeTaskState(task, TaskState.FAILED);
    }

    protected boolean judgeTaskState(JobTask task, TaskState taskState) {
        boolean result = false;
        if (task.getTaskState().equals(taskState.getCode())) {
            result = true;
        }
        return result;
    }

    @Override
    public JobResult getJobResult(List<JobTask> taskList) {
        JobResult result = new JobResult();
        result.setTotalTaskCount(taskList.size());
        int successSize = 0;
        int handlingSize = 0;
        int failSize = 0;
        for (JobTask task : taskList) {
            JobTask t = this.findTask(task.getTaskId());
            if (this.judgeTaskFailed(t)) {
                ++failSize;
                continue;
            }
            if (this.judgeTaskComplete(t)) {
                ++successSize;
                continue;
            }
            ++handlingSize;
        }
        result.setFailTaskCount(failSize);
        result.setHandlingTaskCount(handlingSize);
        result.setSuccessTaskCount(successSize);
        return result;
    }
}

