replace into sc_stat_meter_read_rate_by_building (stat_day,site_id,channel_id,customer_id,building_id,device_count,read_times,real_read_times,un_read_times,read_rate,date_create,date_update)
select
	DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' ),
	site_id,  -- 所有站点
	sys_id,  -- 所有场景
	customer_id,  -- 所有客户
	building_id,  -- 所有建筑
	count(distinct device_id) as device_count, -- 设备总数
	count(1) as read_times,   -- 应抄总数
	SUM(IF(read_status = 2, 1, 0)) as real_read_times, -- 实抄总数 
	SUM(IF(read_status = 1, 1, 0)) as un_read_times,   -- 未抄总数
	FORMAT(SUM(IF(read_status = 2, 1, 0))/ COUNT(1)*100, 2) as read_rate ,-- 抄表率
	now(),
	now()
from
	sc_meter_read_record 
where 
	read_date = DATE_FORMAT( date_add(#{date}, interval -1 day), '%Y%m%d' )
	group by site_id,sys_id,customer_id,building_id

