insert into sc_stat_meter_unread_device_by_building_15day (stat_day,site_id,channel_id,building_id,device_id,date_create)
SELECT
	DATE_FORMAT( date_add( #{date}, INTERVAL - 1 DAY ), '%Y%m%d' ),
	site_id,
	sys_id,
	building_id,
	device_id,
	now()
FROM
	sc_meter_read_record 
WHERE
	read_date < DATE_FORMAT( #{date}, '%Y%m%d' )
AND read_date >= DATE_FORMAT( date_add(#{date}, interval -15 day), '%Y%m%d' )
AND read_status = 1 
GROUP BY
	site_id,
	sys_id,
	building_id,
	device_id 
HAVING
	count(1) = 15