insert into sc_stat_meter_unread_device_by_building_month (stat_day,site_id,channel_id,building_id,device_id,date_create)
SELECT
DATE_FORMAT( date_add( :date, INTERVAL - 1 MONTH ), '%Y%m' ),
t1.site_id,
t1.sys_id,
t1.building_id,
t1.device_id,
now()
FROM(
        SELECT
            site_id,
            sys_id,
            building_id,
            device_id,
            SUM(IF(read_status = 1 ,1,0)) as unread_times,
            SUM(IF(read_status = 2 ,1,0)) as read_times
        FROM
            sc_meter_read_record
        WHERE
            period_diff(date_format(:date , '%Y%m') , date_format(`read_date`, '%Y%m')) =1
        GROUP BY
            site_id,
            sys_id,
            building_id,
            device_id
) t1 WHERE t1.read_times = 0